/* RxCRC32-Test: Calculate CRC-32 of Stored File *
 *                                               *
 * (C) Mads Orbesen Troest & SIRIUS Cybernetics  */

ARG FileName /* Get FileName on CommandLine */
IF FileName = "" THEN EXIT /* Exit if no FileName Specified */

/* Define a BufferSize for the blocks read from the File */
/* Do not set too low as this gives unnecessary calling-overhead! */
/* Set it after how much memory you are willing to spend on it... :-) */

BufferSize = 4096 /* Can't be that bad a size; could be bigger though .-) */

/* Load External RxCRC32 Routines: */

CALL RxFuncAdd "RxCRC32Ver",    "RXCRC32", "RXCRC32VER"
CALL RxFuncAdd "RxCRC32Init",   "RXCRC32", "RXCRC32INIT"
CALL RxFuncAdd "RxCRC32Done",   "RXCRC32", "RXCRC32DONE"
CALL RxFuncAdd "RxCRC32Update", "RXCRC32", "RXCRC32UPDATE"

/* Do some initial chitchat: */

SAY ""
SAY "RxCRC32-Test: Calculate CRC-32 of Stored File, utilising:"
SAY RxCRC32Ver() /* Report Version Information */
SAY ""

/* Initialize the variable CRC for as in CRC-calculation: */

CRC = RxCRC32Init()

/* Calculate CRC-32 of File: */

DO UNTIL LENGTH( Buffer ) \= BufferSize /* Traverse File */
 Buffer = CHARIN( FileName,, BufferSize ) /* Fill Buffer (there may be a faster way :-) */
 CRC = RxCRC32Update( CRC, Buffer ) /* Update CRC with Buffer */
END

/* Complete Calculation: */

CRC = RxCRC32Done( CRC )

/* Report the result: */

SAY "Well, then... CRC-32 : "CRC" (HEX) - Thanks for using RxCRC32 :-)"

